#version 140
#extension GL_EXT_gpu_shader4 : enable
// Tetris Shapes FractalMod01.fsh  by   KilledByAPixel
//https://www.shadertoy.com/view/4dSBzD
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//////////////////////////////////////////////////////////////////////////////////
// Tetris Shapes Fractal - Copyright 2017 Frank Force
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
//////////////////////////////////////////////////////////////////////////////////

const float zoomSpeed			= 0.6;	// how fast to zoom (negative to zoom out)
const float zoomScale			= 0.1;	// how much to multiply overall zoom (closer to zero zooms in)
const int recursionCount		= 5;	// how deep to recurse
const float recursionFadeDepth	= 0.0;	// how deep to fade out
const int glyphSize				= 4;	// width & height of glyph in pixels
const int glyphCount			= 28;// how many glyphs total
const float glyphMargin			= 1.0;	// how much to center the glyph in each pixel
const int glyph[glyphSize*glyphCount] = int[]
(// glyph sheet
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0000, 0x0110, 0x0110, 0x0010, 0x0100, 0x0000, 0x0100, 0x0000, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0000, 0x0010, 0x0100, 0x0010, 0x0100,   
 0x0000, 0x0110, 0x0010, 0x1000, 0x1100, 0x0110, 0x0100, 0x0110, 0x0010, 0x0100, 0x0110, 0x0110, 0x0100, 0x1100, 0x1110, 0x0110, 0x0000, 0x0110, 0x1110, 0x1110, 0x1100, 0x1100, 0x0100, 0x0110, 0x0010, 0x0100, 0x0110, 0x0110, 
 0x1111, 0x0110, 0x1110, 0x1110, 0x0110, 0x1100, 0x0100, 0x0110, 0x0010, 0x0100, 0x0100, 0x0010, 0x1110, 0x0100, 0x0100, 0x0100, 0x1111, 0x0110, 0x0010, 0x1000, 0x0110, 0x0110, 0x0100, 0x0110, 0x0110, 0x0110, 0x0100, 0x0010, 
 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
);//   

//////////////////////////////////////////////////////////////////////////////////
// Precached values and math

const float glyphSizeF = float(glyphSize) + 2.0*glyphMargin;
const float glyphSizeLog = log(glyphSizeF);
const int powTableCount = 10;
const float gsfi = 1.0 / glyphSizeF;
const float powTable[powTableCount] = float[]( 1.0, gsfi, pow(gsfi,2.0), pow(gsfi,3.0), pow(gsfi,4.0), pow(gsfi,5.0), pow(gsfi,6.0), pow(gsfi,7.0), pow(gsfi,8.0), pow(gsfi,9.0));
const float e = 2.718281828459;
const float pi = 3.14159265359;

float RandFloat(int i) { return (fract(sin(float(i)) * 43758.5453)); }
int RandInt(int i) { return int(100000.0*RandFloat(i)); }

vec3 HsvToRgb(vec3 c) 
{
    float s = c.y * c.z;
    float s_n = c.z - s * .5;
    return vec3(s_n) + vec3(s) * cos(2.0 * pi * (c.x + vec3(1.0, 0.6666, .3333)));
}

//////////////////////////////////////////////////////////////////////////////////
// Color and image manipulation

float GetRecursionFade(int r, float timePercent)
{
    if (r > recursionCount)
        return timePercent;
    
    return 1.0;
    
    // fade in and out recusion
    float rt = max(float(r) - timePercent - recursionFadeDepth, 0.0);
    float rc = float(recursionCount) - recursionFadeDepth;
    return rt / rc;
}

vec3 InitPixelColor() { return vec3(0); }
vec3 CombinePixelColor(vec3 color, float timePercent, int i, int r, vec2 pos, ivec2 glyphPos, ivec2 glyphPosLast)
{
    vec3 myColor = vec3
    (
    	mix(0.0, 1.0, RandFloat(i + r + 419*glyphPosLast.x + 773*glyphPosLast.y)),
    	mix(0.0, 1.0, RandFloat(i + r + 929*glyphPosLast.x + 499*glyphPosLast.y)),
        mix(0.0, 0.45, RandFloat(i + r + 929*glyphPosLast.x + 499*glyphPosLast.y))
    );
    
    // vary light and dark colors
    if ((i+r)%2 == 0)
        myColor.z = 1.0 - myColor.z;

    // combine with my color
    float f = GetRecursionFade(r, timePercent);
    return mix(color, myColor, f);
}

vec3 FinishPixel(vec3 color, vec2 uv)
{
    // color wander
    color.x += (0.05*uv.y + 0.05*uv.x + 0.05*iTime);
    
    // convert to rgb
    color = HsvToRgb(color);
    return color;
}

vec2 InitUV(vec2 uv)
{
    // rotate over time
	float timePercent = iTime*zoomSpeed;
	int iterations = int(timePercent);
	timePercent -= floor(timePercent);
    
    // generate random rotations that will never have the same number in a row
    int r1i = 2*(RandInt(iterations-1+10) % 2);
    if ((iterations-1) % 2 == 0)
        r1i += 1;
    int r2i = 2*(RandInt(iterations+10) % 2);
    if ((iterations) % 2 == 0)
        r2i += 1;
    float r1 = (pi/2.0)*float(r1i);
    float r2 = (pi/2.0)*float(r2i);
    if (r2 - r1 > pi)
        r2 -= 2.0*pi;
    if (r1 - r2 > pi)
        r1 -= 2.0*pi;
    float turnRate = 0.25;
    
    float theta = mix(r1, r2, ((1.0 / turnRate)*max(timePercent-(1.0-turnRate), 0.0)));
	float c = cos(theta);
	float s = sin(theta);
	uv = vec2((uv.x*c - uv.y*s), (uv.x*s + uv.y*c));
    return uv;
}

//////////////////////////////////////////////////////////////////////////////////
// Fractal functions

int GetFocusGlyph(int i) { return RandInt(i) % glyphCount; }
int GetGlyphPixelRow(int y, int g) { return glyph[g + (glyphSize - 1 - y)*glyphCount]; }
int GetGlyph(int i, ivec2 glyphPos, ivec2 glyphPosLast)
{ 
    int seed = i + glyphPos.x * 313 + glyphPos.y * 411 + glyphPosLast.x * 557 + glyphPosLast.y * 121;
    return RandInt(seed) % glyphCount; 
}

int GetGlyphPixel(ivec2 pos, int g)
{
	if (pos.x >= glyphSize || pos.y >= glyphSize)
		return 0;

    // pull glyph out of hex
	int glyphRow = GetGlyphPixelRow(pos.y, g);
    return 1 & (glyphRow >> (glyphSize - 1 - pos.x) * 4);
}

ivec2 GetFocus(int i)
{
    // find a random valid pixel in glyph
    int g = GetFocusGlyph(i-1);
    int c = 0;
    for (int y = 0; y < glyphSize; ++y)
    {
		int glyphRow = GetGlyphPixelRow(y, g);
        for (int x = 0; x < glyphSize; ++x)
            c += (1 & (glyphRow >> 4*x));
    }

    c -= RandInt(i) % c;
    for (int y = 0; y < glyphSize; ++y)
    {
		int glyphRow = GetGlyphPixelRow(y, g);
        for (int x = 0; x < glyphSize; ++x)
        {
            c -= (1 & (glyphRow >> 4*x));
            if (c == 0)
                return ivec2(glyphSize - 1 - x,y);
        }
    }
}
        
// get recursion depth of pos, where pos is 0-1 point in the glyph
vec3 GetPixelFractal(vec2 pos, int iterations, float timePercent)
{
	ivec2 glyphPosLast = GetFocus(iterations-2);
	ivec2 glyphPos =     GetFocus(iterations-1);
    int g = GetFocusGlyph(iterations-1);
	
	vec3 color = InitPixelColor();
	for (int r = 0; r <= recursionCount + 1; ++r)
	{
        color = CombinePixelColor(color, timePercent, iterations, r, pos, glyphPos, glyphPosLast);
        
        //if (r == 1 && glyphPos == GetFocus(iterations+r-1))
	    //    color.z = 1.0; // debug - show focus
        
        int glyphValue = 0;
		if (r <= recursionCount)
        {
            // offset and bounds check
            pos -= vec2(glyphMargin/glyphSizeF);

            // get glyph and pos within that glyph
            glyphPosLast = glyphPos;
            glyphPos = ivec2(pos * glyphSizeF);

            // check depth
            glyphValue = GetGlyphPixel(glyphPos, g);
        }
            
		if (glyphValue == 0 || pos.x < 0.0 || pos.y < 0.0)
			return color;
        
        // update pos
		pos *= glyphSizeF;
		pos -= vec2(floor(pos));
        
        if (glyphPos == GetFocus(iterations+r))
            g = GetFocusGlyph(iterations+r); // inject correct glyph
        else
            g = GetGlyph(iterations + r, glyphPos, glyphPosLast);
	}
}
 
//////////////////////////////////////////////////////////////////////////////////
void main (void)	
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	// use square aspect ratio
	vec2 uv = gl_FragCoord.xy;
	uv = gl_FragCoord.xy / iResolution.y;
	uv -= vec2(0.5*iResolution.x / iResolution.y, 0.5);
    vec2 uv2 = uv;
    uv = InitUV(uv);
	
	// get time 
	float timePercent = iTime*zoomSpeed;
	int iterations = int(timePercent);
	timePercent -= floor(timePercent);
    
    // rotate then zoom
    //float turnRate = 0.75;//(abs(r1-r2) > pi - 0.1)? 0.5 : 0.75;
    //timePercent = (min((timePercent)*(1.0/turnRate), 1.0));
	
	// update zoom, apply pow to make rate constant
	float zoom = pow(e, -glyphSizeLog*timePercent);
	zoom *= zoomScale;
    
	// get offset
	vec2 offset = vec2(0);
	for (int i = 0; i < powTableCount; ++i)
		offset += ((vec2(GetFocus(iterations+i)) + vec2(glyphMargin)) / glyphSizeF) * powTable[i];
    
	// apply zoom & offset
    vec2 uvFractal = uv * zoom + offset;
	
	// check pixel recursion depth
	vec3 pixelFractalColor = GetPixelFractal(uvFractal, iterations, timePercent);
    pixelFractalColor = FinishPixel(pixelFractalColor, uv2);
    
	// apply final color
	gl_FragColor = vec4(pixelFractalColor, 1.0);
}